--ORIGINALLY BASED ON A SCRIPT BY @lucho_gamer ON DISCORD!!
--REWRITTEN BY @larryfrosty ON DISCORD!!

function onSpawnNote(id, direction, noteType, isSustainNote)
	if noteType == 'Trail Note' then
		setPropertyFromGroup('notes', id, 'noAnimation', true)
	end
end

function getIconColor(chr)
	return getColorFromHex(rgbToHex(getProperty(chr .. ".healthColorArray")))
end

function rgbToHex(array)
	return string.format('%.2x%.2x%.2x', array[1], array[2], array[3])
end

function goodNoteHit(id, direction, noteType, isSustainNote)
	if noteType == 'Trail Note' then
		updateGData('boyfriend', direction)
		createGhost('boyfriend')
	end
end

function opponentNoteHit(id, direction, noteType, isSustainNote)
	if noteType == 'Trail Note' then
		updateGData('dad', direction)
		createGhost('dad')
	end
end

function createGhost(char)
	local funny = getSongPosition()..getRandomInt(1, 1000)
	createInstance(char..'Ghost'..funny, 'objects.Character', {getProperty(char..'.x'), getProperty(char..'.y'), getProperty(char..'.curCharacter'), getProperty(char..'.isPlayer')})
	setProperty(char..'Ghost'..funny..'.offset.x', _G[char..'GhostData.offsetX'])
	setProperty(char..'Ghost'..funny..'.offset.y', _G[char..'GhostData.offsetY'])
	setProperty(char..'Ghost'..funny..'.color', getIconColor(char))
	addInstance(char..'Ghost'..funny)
	playAnim(char..'Ghost'..funny, _G[char..'GhostData.frameName'])
	doTweenAlpha(char..'Ghost'..funny..'delete', char..'Ghost'..funny, 0, 0.4)
end

function onTweenCompleted(tag)
	if (tag:sub(#tag- 5, #tag)) == 'delete' then
		callMethod('remove', {instanceArg(tag:sub(1, #tag - 6))})
	end
end

function updateGData(char, data)
	_G[char..'GhostData.frameName'] = getProperty('singAnimations')[data+1]
	_G[char..'GhostData.offsetX'] = getProperty(char..'.offset.x')
	_G[char..'GhostData.offsetY'] = getProperty(char..'.offset.y')
end